/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.internal.action.AttachmentManage;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.AttachmentService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.IOException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public class PanelButtonAttachment
extends PanelButton {
    private AttachmentService service = null;
    private MessageConsumer onAdd = new OnAdd();
    private MessageConsumer onDel = new OnDel();
    private int count = 0;

    public PanelButtonAttachment() {
        super("mail-attachment.png", new AttachmentManage(), Application.getI18n().tr("Datei-Anh\u00e4nge"));
        this.service = (AttachmentService)Application.getBootLoader().getBootable(AttachmentService.class);
        try {
            this.count = this.service.find().size();
        }
        catch (IOException e) {
            Logger.error((String)"unable to get attachment list", (Throwable)e);
        }
        this.update();
        Application.getMessagingFactory().getMessagingQueue("jameica.attachment.added").registerMessageConsumer(this.onAdd);
        Application.getMessagingFactory().getMessagingQueue("jameica.attachment.deleted").registerMessageConsumer(this.onDel);
    }

    @Override
    protected Control getControl() {
        Control c = super.getControl();
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().getMessagingQueue("jameica.attachment.added").unRegisterMessageConsumer(PanelButtonAttachment.this.onAdd);
                Application.getMessagingFactory().getMessagingQueue("jameica.attachment.deleted").unRegisterMessageConsumer(PanelButtonAttachment.this.onDel);
            }
        });
        return c;
    }

    private void update() {
        try {
            if (this.count == 0) {
                this.setTooltip(Application.getI18n().tr("Keine Dateianh\u00e4nge"));
            } else if (this.count == 1) {
                this.setTooltip(Application.getI18n().tr("1 Dateianhang"));
            } else {
                this.setTooltip(Application.getI18n().tr("{0} Dateianh\u00e4nge", Integer.toString(this.count)));
            }
            this.setText(this.count > 0 ? Integer.toString(this.count) : "");
        }
        catch (Exception e) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(e.getMessage(), 1));
        }
    }

    @Override
    public boolean isEnabled() {
        return GUI.getCurrentView().canAttach();
    }

    private class OnAdd
    implements MessageConsumer {
        private OnAdd() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ++PanelButtonAttachment.this.count;
                    PanelButtonAttachment.this.update();
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }

    private class OnDel
    implements MessageConsumer {
        private OnDel() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    --PanelButtonAttachment.this.count;
                    PanelButtonAttachment.this.update();
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }
}

